<?php
	$currenturl = remove_query_arg( 'delete', sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) );
	$currenturl = remove_query_arg( 'view', $currenturl );
	$currenturl = remove_query_arg( 'trust', $currenturl );
	$currenturl = remove_query_arg( 'trustchanged', $currenturl );
?>


<div class="nav-tab-wrapper">
	<button class="nav-tab tablinks" onclick="openTabmalware(event, 'scan_view')" id="malware_view">Malware Scan Modes</button>
	<button class="nav-tab tablinks" onclick="openTabmalware(event, 'settings_scan')" id="scan_set">Custom Scan Settings</button>
	<input type = "hidden" id = "wpns_report_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wpns-report-load' ) ); ?>" >
</div>
<div id="mo_scan_message" style=" padding-top:8px"></div>
<div class="tabcontent" id="scan_view">
	<div class="mo_wpns_divided_layout">
		<table style="width: 100%;">
			<tr>
				<td style="width:100%;vertical-align:top;" id="configurationForm">
					<?php require_once $mmp_dir_name . 'controllers' . DIRECTORY_SEPARATOR . 'malware_scanner' . DIRECTORY_SEPARATOR . 'scan_malware_summary.php'; ?>
			</tr>
		</table>
	</div>
</div>
<div class="tabcontent" id="settings_scan">
	<div class="mo_wpns_divided_layout">
		<table style="width: 100%;">
			<tr>
				<td style="width:100%;vertical-align:top;" id="configurationForm">
					<?php require_once $mmp_dir_name . 'controllers' . DIRECTORY_SEPARATOR . 'malware_scanner' . DIRECTORY_SEPARATOR . 'scan_malware_settings.php'; ?>
			</tr>
		</table>
	</div>
</div>
<script>
	function openTabmalware(evt, tabname){
		jQuery('#mo_scan_message').hide();
		var i, tablinks, tabcontent;
		tabcontent = document.getElementsByClassName("tabcontent");
		for (i = 0; i < tabcontent.length; i++) {
			tabcontent[i].style.display = "none";
		}
		tablinks = document.getElementsByClassName("tablinks");
		for (i = 0; i < tablinks.length; i++) {
			tablinks[i].className = tablinks[i].className.replace(" nav-tab-active", "");
		}
		document.getElementById(tabname).style.display = "block";
		localStorage.setItem("lastTabmalware", tabname);
		evt.currentTarget.className += " nav-tab-active";
		if(tabname == "scan_report"){
			var data={
				'action':'mo_wpns_malware_redirect',
				'call_type':'malware_scan_last_result',
				'nonce': '<?php echo esc_js( wp_create_nonce( 'mmp-scan-settings' ) ); ?>',
			};
			jQuery.post(ajaxurl ,data, function(response){
				jQuery("#reports_table tbody").html(response);
			});
		}else if(tabname == "settings_scan"){
			document.getElementById("scan_set").click();
		}
	}

	var tab = localStorage.getItem("lastTabmalware");
	if(tab == "scan_view"){
		document.getElementById("malware_view").click();
	}
	else if(tab == "settings_scan"){
		document.getElementById("scan_set").click();
	}
	else{
		document.getElementById("malware_view").click();
	}

</script>
